/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.features;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsdim.dimension.features.IFeature;
import mcjty.rftoolsdim.dimension.features.instances.CubeFeature;
import mcjty.rftoolsdim.dimension.features.instances.SphereFeature;
import mcjty.rftoolsdim.dimension.features.instances.TendrilsFeature;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeSet;

public enum FeatureType {
    NONE("none", KnowledgeSet.SET1, null),
    CUBES("cubes", KnowledgeSet.SET2, new CubeFeature(false, false)),
    HOLLOW_CUBES("hollow_cubes", KnowledgeSet.SET2, new CubeFeature(true, false)),
    LIQUID_CUBES("liquid_cubes", KnowledgeSet.SET2, new CubeFeature(true, true)),
    SPHERES("spheres", KnowledgeSet.SET3, new SphereFeature(false, false)),
    HOLLOW_SPHERES("hollow_spheres", KnowledgeSet.SET3, new SphereFeature(true, false)),
    LIQUID_SPHERES("liquid_spheres", KnowledgeSet.SET3, new SphereFeature(true, true)),
    TENDRILS("tendrils", KnowledgeSet.SET4, new TendrilsFeature());

    private final String name;
    private final KnowledgeSet set;
    private final IFeature feature;
    private static final Map<String, FeatureType> FEATURE_BY_NAME;

    private FeatureType(String name, KnowledgeSet set, IFeature feature) {
        this.name = name;
        this.set = set;
        this.feature = feature;
    }

    public String getName() {
        return this.name;
    }

    public KnowledgeSet getSet() {
        return this.set;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public static FeatureType byName(String name) {
        return FEATURE_BY_NAME.get(name.toLowerCase());
    }

    static {
        FEATURE_BY_NAME = new HashMap<String, FeatureType>();
        for (FeatureType type : FeatureType.values()) {
            FEATURE_BY_NAME.put(type.getName(), type);
        }
    }
}

